//	TorusGamesHelpChoiceController.h
//
//	© 2021 by Jeff Weeks
//	See TermsOfUse.txt

#import <UIKit/UIKit.h>
#import "GeometryGamesPopover.h"
#import "TorusGames-Common.h"	//	for GameType

@protocol TorusGamesHelpChoiceDelegate
- (BOOL)prefersStatusBarHidden;
- (void)dismissHelp;
- (bool)practiceBoardIsSelected;
- (void)selectPracticeBoard;
- (void)requestGame:(GameType)aNewGame;
#ifdef SCIENCE_CENTER_VERSION
- (void)userIsStillPlaying;
#endif
@end

@interface TorusGamesHelpChoiceController : UITableViewController
	<UITableViewDataSource, UITableViewDelegate, GeometryGamesPopover>

- (id)initWithDelegate:(NSObject<TorusGamesHelpChoiceDelegate> *)aDelegate;
- (BOOL)prefersStatusBarHidden;
- (void)viewWillAppear:(BOOL)animated;

//	GeometryGamesPopover
- (void)adaptNavBarForHorizontalSize:(UIUserInterfaceSizeClass)aHorizontalSizeClass;

//	UITableViewDataSource
- (NSInteger)numberOfSectionsInTableView:(UITableView *)aTableView;
- (NSString *)tableView:(UITableView *)aTableView titleForHeaderInSection:(NSInteger)aSection;
- (NSInteger)tableView:(UITableView *)aTableView numberOfRowsInSection:(NSInteger)aSection;
- (UITableViewCell *)tableView:(UITableView *)aTableView cellForRowAtIndexPath:(NSIndexPath *)anIndexPath;

//	UITableViewDelegate
- (NSIndexPath *)tableView:(UITableView *)aTableView willSelectRowAtIndexPath:(NSIndexPath *)anIndexPath;

@end
